'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Butto_SeitenvorschauOeffnen_Click()
On Error GoTo ERROR_Butto_SeitenvorschauOeffnen_Click
    
    Dim dbs As Database, rst As Recordset, qdf As QueryDef
    Dim strFilterRechnung, strFilterKunde, strFilterSteuer As String
    
    'Eigenen Formularnamen merken fr Aktualisierung
    FormularName = "Kunden"
    FormularBereich = "Rechnungen"
'    KundenNrIntern = Me.lfd_Nr.Value
    KundenNrIntern = Me.Parent.lfd_Nr.Value
    
    'Tabelle ffnen
    Set dbs = CurrentDb
'    Set rst = Me.Rechnungen.Form.RecordsetClone
    Set rst = Me.RecordsetClone
    
    'wenn Datensatz vorhanden, dann Rechnung anzeigen...
    If (rst.RecordCount = 0) Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Keine Rechnungen vorhanden.", vbInformation, "Hinweis"
    Else
    
        'Hinweis zum Warten anzeigen
        DoCmd.OpenForm "Bitte_warten"
        Forms![Bitte_warten].Repaint
    
            'Gre des Reportfensters und Berichts-Zoom optimieren
            'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
            AnwendungGroesseErmitteln
    
        'SQL-Texte vorbereiten
        strFilterRechnung = "SELECT * FROM Rechnungen WHERE Rechnungen.lfd_Nr=" & AktRechnung
        strFilterKunde = "SELECT * FROM Kunden WHERE Kunden.lfd_Nr=" & AktKunde
        strFilterSteuer = "SELECT * FROM Rechnungen_MwSt WHERE Rechnungen_MwSt.lfd_Nr_Re=" & AktRechnung & " ORDER BY Rechnungen_MwSt.Prozent;"
        'vorhandene Abfragen erst lschen und mit neuem SQL-Text erstellen
        dbs.QueryDefs.Refresh
        On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
        dbs.QueryDefs.Delete "Abf_RechnungDaten"
        On Error GoTo ERROR_Butto_SeitenvorschauOeffnen_Click   'Fehlerbehandlung wieder einschalten
        Set qdf = dbs.CreateQueryDef("Abf_RechnungDaten", strFilterRechnung)
        On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
        dbs.QueryDefs.Delete "Abf_RechnungKunde"
        On Error GoTo ERROR_Butto_SeitenvorschauOeffnen_Click   'Fehlerbehandlung wieder einschalten
        Set qdf = dbs.CreateQueryDef("Abf_RechnungKunde", strFilterKunde)
        On Error Resume Next                                'Fehlermeldung bei fehlender Tabelle ignorieren
        dbs.QueryDefs.Delete "Abf_RechnungMwSt"
        On Error GoTo ERROR_Butto_SeitenvorschauOeffnen_Click        'Fehlerbehandlung wieder einschalten
        Set qdf = dbs.CreateQueryDef("Abf_RechnungMwSt", strFilterSteuer)
        dbs.QueryDefs.Refresh
        'Rechnungsformular anzeigen
        ReOriginal = False
        On Error GoTo ERROR_Formular                        'bei fehlendem Formular auf Standard ausweichen
        DoCmd.OpenReport FormularRechnungName, acPreview
ERROR_Formular_weiter:
        On Error GoTo ERROR_Butto_SeitenvorschauOeffnen_Click
        
            'Berichtsfenster nun auf Anwendungsgre zoomen
            DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
            'Berichtsvorschau auf ganzes Blatt zoomen
            DoCmd.RunCommand acCmdFitToWindow
        
        'Tabellen schlieen
        qdf.Close
        rst.Close
        Set dbs = Nothing
    End If

EXIT_Butto_SeitenvorschauOeffnen_Click:
    Exit Sub
    
ERROR_Butto_SeitenvorschauOeffnen_Click:
    MsgBox err.Description
    Resume EXIT_Butto_SeitenvorschauOeffnen_Click
    
ERROR_Formular:
    DoCmd.OpenReport "Rechnung_Hauptformular", acPreview
    Resume ERROR_Formular_weiter

End Sub

Private Sub Button_RechnungsbuchOeffnen_Click()
On Error GoTo Err_Button_RechnungsbuchOeffnen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
'    'Prfen, ob Rechnungstabelle leer ist
'    Set dbs = CurrentDb
'    Set rst = dbs.OpenRecordset("Rechnungen")
'    If rst.RecordCount = 0 Then
'        rst.Close
'        Set dbs = Nothing
'        MsgBox "Es wurden noch keine Rechnungen generiert.", vbInformation, "Hinweis"
'        Exit Sub
'    End If
'    rst.Close
'    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Rechnungsbuch ffnen
    FormularName = "Rechnungen_Uebersicht"
    
    DoCmd.Close acForm, FormularName, acSaveYes
    DoCmd.OpenForm FormularName, , , , , , AktRechnung
    
    
Exit_Button_RechnungsbuchOeffnen_Click:
    Exit Sub

Err_Button_RechnungsbuchOeffnen_Click:
    MsgBox err.Description
    Resume Exit_Button_RechnungsbuchOeffnen_Click

End Sub

Private Sub Form_Current()
    'merken fr Bearbeitung
    AktRechnung = Me.lfd_Nr.Value
    
End Sub

Private Sub RechnungStorno_Click()
On Error GoTo Err_RechnungStorno_Click


    'DoCmd.DoMenuItem acFormBar, acEditMenu, 8, , acMenuVer70
    'DoCmd.DoMenuItem acFormBar, acEditMenu, 6, , acMenuVer70

Exit_RechnungStorno_Click:
    Exit Sub

Err_RechnungStorno_Click:
    MsgBox err.Description
    Resume Exit_RechnungStorno_Click
    
End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Netto.Format = "Currency"
    Me.MwSt.Format = "Currency"
    Me.Brutto.Format = "Currency"
End Sub
